package ru.yandex.qe.dispenser.domain.juggler;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.juggler.notifications.OnChangeKwargs;
import ru.yandex.qe.dispenser.domain.juggler.notifications.StartrekKwargs;
import ru.yandex.qe.dispenser.domain.juggler.notifications.Template;
import ru.yandex.qe.dispenser.domain.juggler.notifications.TemplateKwargs;
import ru.yandex.qe.dispenser.domain.juggler.notifications.TemplateKwargsFull;
import ru.yandex.qe.json.DefaultJsonMapper;

@ParametersAreNonnullByDefault
public class JugglerNotification {
    @NotNull
    private final Template template_name;
    @Nullable
    private final TemplateKwargs template_kwargs;
    @Nullable
    private final String description;

    public JugglerNotification(@JsonProperty("template_name") final Template template,
                               @JsonProperty("template_kwargs") final TemplateKwargsFull kwargs,
                               @Nullable @JsonProperty("description") final String description) {
        template_name = template;
        switch (template) {
            case ON_STATUS_CHANGE:
            case ON_DESC_CHANGE:
                template_kwargs = new OnChangeKwargs(kwargs.getLogin(), kwargs.getMethod(), kwargs.getStatus());
                break;
            case STARTREK:
                template_kwargs = new StartrekKwargs(kwargs.getQueue(),
                        kwargs.getComponents(),
                        kwargs.getFollowers(),
                        kwargs.getStatus());
                break;
            case GOLEM:
            default:
                template_kwargs = null;
        }
        this.description = StringUtils.trimToNull(description);
    }

    @JsonIgnore
    public JugglerNotification(final Template template_name,
                               @Nullable final TemplateKwargs template_kwargs,
                               @Nullable final String description) {
        this.template_name = template_name;
        this.template_kwargs = template_kwargs;
        this.description = StringUtils.trimToNull(description);
    }

    @NotNull
    public Template getTemplate_name() {
        return template_name;
    }

    @Nullable
    public TemplateKwargs getTemplate_kwargs() {
        return template_kwargs;
    }

    @Nullable
    public String getDescription() {
        return description;
    }

    @Override
    public String toString() {
        try {
            return new DefaultJsonMapper().writeValueAsString(this);
        } catch (final JsonProcessingException e) {
            return "{" +
                    "template_name : '" + template_name + '\'' +
                    ", template_kwargs : " + template_kwargs +
                    ", description : '" + description + '\'' +
                    '}';
        }
    }
}
