package ru.yandex.qe.dispenser.domain.juggler.notifications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;

import ru.yandex.qe.json.DefaultJsonMapper;

import static java.util.Collections.unmodifiableList;

public class OnChangeKwargs implements TemplateKwargs {
    @Nullable
    private final List<String> login;
    @Nullable
    private final List<String> method;
    @Nullable
    private final List<Object> status;

    public OnChangeKwargs(@Nullable @JsonProperty("login") final Collection<String> login,
                          @Nullable @JsonProperty("method") final List<String> method,
                          @Nullable @JsonProperty("status") final Collection<Object> status) {
        this.login = login == null ? null : new ArrayList<>(login);
        this.method = method == null ? null : new ArrayList<>(method);
        this.status = status == null ? null : new ArrayList<>(status);
    }

    @Nullable
    public List<String> getLogin() {
        return login == null ? null : unmodifiableList(login);
    }

    @Nullable
    public List<String> getMethod() {
        return method == null ? null : unmodifiableList(method);
    }

    @Nullable
    public List<Object> getStatus() {
        return status;
    }

    @Override
    public String toString() {
        try {
            return new DefaultJsonMapper().writeValueAsString(this);
        } catch (final JsonProcessingException ignored) {
            return "{" +
                    "login : '" + login + '\'' +
                    ", method : " + method +
                    ", status : " + status +
                    '}';
        }
    }
}
