package ru.yandex.qe.dispenser.domain.juggler.notifications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;

import static java.util.Collections.unmodifiableList;

public class StartrekKwargs implements TemplateKwargs {
    @Nullable
    private final String queue;
    @Nullable
    private final List<String> components;
    @Nullable
    private final List<String> followers;
    @Nullable
    private final List<Object> status;

    public StartrekKwargs(@Nullable @JsonProperty("queue") final String queue,
                          @Nullable @JsonProperty("components") final Collection<String> components,
                          @Nullable @JsonProperty("followers") final Collection<String> followers,
                          @Nullable @JsonProperty("status") final Collection<Object> status) {
        this.queue = StringUtils.trimToNull(queue);
        this.components = components == null ? null : new ArrayList<>(components);
        this.followers = followers == null ? null : new ArrayList<>(followers);
        this.status = status == null ? null : new ArrayList<>(status);
    }

    @Nullable
    public String getQueue() {
        return queue;
    }

    @Nullable
    public List<String> getComponents() {
        return components == null ? null : unmodifiableList(components);
    }

    @Nullable
    public List<String> getFollowers() {
        return followers == null ? null : unmodifiableList(followers);
    }

    @Nullable
    public List<Object> getStatus() {
        return status;
    }

}
