package ru.yandex.qe.dispenser.domain.juggler.notifications;

import java.util.Map;
import java.util.Set;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import static java.util.Arrays.stream;
import static java.util.Collections.unmodifiableMap;
import static java.util.function.Function.identity;
import static java.util.stream.Collectors.toMap;

public enum Template {
    ON_STATUS_CHANGE("on_status_change"), ON_DESC_CHANGE("on_desc_change"), GOLEM("golem"), STARTREK("startrek");
    private static final Map<String, Template> NOTIFICATIONS = unmodifiableMap(stream(values()).collect(toMap(Template::getApiName, identity())));
    private final String apiName;

    public static Set<String> supportedNotifications() {
        return NOTIFICATIONS.keySet();
    }

    @JsonCreator
    @Nullable
    public static Template value(@Nullable String aggregator) {
        return NOTIFICATIONS.getOrDefault(aggregator, null);
    }

    @JsonValue
    public String getApiName() {
        return apiName;
    }

    @SuppressWarnings("all")
    private Template(final String apiName) {
        this.apiName = apiName;
    }
}
