package ru.yandex.qe.dispenser.domain.juggler.notifications;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang.StringUtils;

import static java.util.Collections.unmodifiableList;

public class TemplateKwargsFull {
    private final List<String> login;
    private final Boolean golem_responsible;
    private final List<Object> status; //String or Status
    private final List<String> method;
    private final Integer day_start;
    private final Integer day_end;
    private final String time_start;
    private final String time_end;
    private final Integer calendar_id;
    private final Boolean ignore_gaps;
    private final Boolean ignore_golem;
    private final Boolean ignore_weekends;
    private final Integer repeat;
    private final Integer delay;
    private final String queue;
    private final Integer issue;
    private final List<String> components;
    private final List<String> followers;

    public TemplateKwargsFull(@JsonProperty("login") final List<String> login,
                              @JsonProperty("golem_responsible") final Boolean golem_responsible,
                              @JsonProperty("status") final List<Object> status,
                              @JsonProperty("method") final List<String> method,
                              @JsonProperty("day_start") final Integer day_start,
                              @JsonProperty("day_end") final Integer day_end,
                              @JsonProperty("time_start") final String time_start,
                              @JsonProperty("time_end") final String time_end,
                              @JsonProperty("calendar_id") final Integer calendar_id,
                              @JsonProperty("ignore_gaps") final Boolean ignore_gaps,
                              @JsonProperty("ignore_golem") final Boolean ignore_golem,
                              @JsonProperty("ignore_weekends") final Boolean ignore_weekends,
                              @JsonProperty("repeat") final Integer repeat,
                              @JsonProperty("delay") final Integer delay,
                              @JsonProperty("queue") final String queue,
                              @JsonProperty("issue") final Integer issue,
                              @JsonProperty("components") final List<String> components,
                              @JsonProperty("followers") final List<String> followers) {
        this.login = login == null ? null : new ArrayList<>(login);
        this.golem_responsible = golem_responsible;
        this.status = status == null ? null : new ArrayList<>(status);
        this.method = method == null ? null : new ArrayList<>(method);
        this.day_start = day_start;
        this.day_end = day_end;
        this.time_start = StringUtils.trimToNull(time_start);
        this.time_end = StringUtils.trimToNull(time_end);
        this.calendar_id = calendar_id;
        this.ignore_gaps = ignore_gaps;
        this.ignore_golem = ignore_golem;
        this.ignore_weekends = ignore_weekends;
        this.repeat = repeat;
        this.delay = delay;
        this.queue = StringUtils.trimToNull(queue);
        this.issue = issue;
        this.components = components == null ? null : new ArrayList<>(components);
        this.followers = components == null ? null : new ArrayList<>(followers);
    }

    public List<String> getLogin() {
        return login == null ? null : unmodifiableList(login);
    }

    public Boolean isGolem_responsible() {
        return golem_responsible;
    }

    public List<Object> getStatus() {
        return status == null ? null : unmodifiableList(status);
    }

    public List<String> getMethod() {
        return method == null ? null : unmodifiableList(method);
    }

    public Integer getDay_start() {
        return day_start;
    }

    public Integer getDay_end() {
        return day_end;
    }

    public String getTime_start() {
        return time_start;
    }

    public String getTime_end() {
        return time_end;
    }

    public Integer getCalendar_id() {
        return calendar_id;
    }

    public Boolean isIgnore_gaps() {
        return ignore_gaps;
    }

    public Boolean isIgnore_golem() {
        return ignore_golem;
    }

    public Boolean isIgnore_weekends() {
        return ignore_weekends;
    }

    public Integer getRepeat() {
        return repeat;
    }

    public Integer getDelay() {
        return delay;
    }

    public String getQueue() {
        return queue;
    }

    public Integer getIssue() {
        return issue;
    }

    public List<String> getComponents() {
        return components == null ? null : unmodifiableList(components);
    }

    public List<String> getFollowers() {
        return followers == null ? null : unmodifiableList(followers);
    }

    @Override
    public String toString() {
        return "{" +
                "login : " + login +
                ", golem_responsible : " + golem_responsible +
                ", status : " + status +
                ", method : " + method +
                ", day_start : " + day_start +
                ", day_end : " + day_end +
                ", time_start : '" + time_start + '\'' +
                ", time_end : '" + time_end + '\'' +
                ", calendar_id : " + calendar_id +
                ", ignore_gaps : " + ignore_gaps +
                ", ignore_golem : " + ignore_golem +
                ", ignore_weekends : " + ignore_weekends +
                ", repeat : " + repeat +
                ", delay : " + delay +
                ", queue : '" + queue + '\'' +
                ", issue : " + issue +
                ", components : " + components +
                ", followers : " + followers +
                '}';
    }
}
