package ru.yandex.qe.dispenser.domain.lock;

import java.io.Closeable;

import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import ru.yandex.qe.dispenser.domain.dao.DiJdbcTemplate;

@Deprecated
public class DBLock implements DistrebutedLock {
    private static final String ACQUIRE_QUEERY = "SELECT * FROM request_lock WHERE id = :id FOR UPDATE";

    private final int buckets;

    @Autowired
    private DiJdbcTemplate jdbcTemplate;

    public DBLock(final int buckets) {
        this.buckets = buckets;
    }

    @Override
    @Transactional(propagation = Propagation.MANDATORY)
    public Closeable lock(@NotNull final Object key) {
        final int lockId = Math.abs(key.hashCode()) % buckets;
        jdbcTemplate.execute(ACQUIRE_QUEERY, new MapSqlParameterSource("id", lockId), rs -> null);
        return () -> {
        };
    }
}
