package ru.yandex.qe.dispenser.domain.lock;

import java.io.Closeable;
import java.util.concurrent.locks.ReentrantLock;

import org.jetbrains.annotations.NotNull;

public class LocalLock implements DistrebutedLock {
    private final ReentrantLock[] locks;
    private final int buckets;

    public LocalLock(final int buckets) {
        this.buckets = buckets;
        this.locks = new ReentrantLock[buckets];
        for (int i = 0; i < buckets; ++i) {
            this.locks[i] = new ReentrantLock();
        }
    }

    @Override
    public Closeable lock(final @NotNull Object key) {
        final ReentrantLock lock = getLock(key);
        lock.lock();
        return lock::unlock;
    }

    private ReentrantLock getLock(@NotNull final Object key) {
        return locks[Math.abs(key.hashCode()) % buckets];
    }
}
