package ru.yandex.qe.dispenser.domain.mds;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public class MdsMarketingStorage {
    private final long id;
    private final long abcServiceId;
    private final StorageType type;
    private final long storage;

    public MdsMarketingStorage(final long id, final long abcServiceId, final StorageType type, final long storage) {
        this.id = id;
        this.abcServiceId = abcServiceId;
        this.type = type;
        this.storage = storage;
    }

    @JsonProperty("id")
    public long getId() {
        return id;
    }

    @JsonProperty("abcServiceId")
    public long getAbcServiceId() {
        return abcServiceId;
    }

    @JsonProperty("type")
    public StorageType getType() {
        return type;
    }

    @JsonProperty("storage")
    public long getStorage() {
        return storage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MdsMarketingStorage that = (MdsMarketingStorage) o;
        return id == that.id &&
                abcServiceId == that.abcServiceId &&
                storage == that.storage &&
                type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, abcServiceId, type, storage);
    }

    @Override
    public String toString() {
        return "MdsMarketingStorage{" +
                "id=" + id +
                ", abcServiceId=" + abcServiceId +
                ", type=" + type +
                ", storage=" + storage +
                '}';
    }

}
