package ru.yandex.qe.dispenser.domain.mds;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class MdsRawStorage {
    private final long id;
    private final long storage;

    @JsonCreator
    public MdsRawStorage(@JsonProperty("id") final long id,
                         @JsonProperty("storage") final long storage) {
        this.id = id;
        this.storage = storage;
    }

    public long getId() {
        return id;
    }

    public long getStorage() {
        return storage;
    }
}
