package ru.yandex.qe.dispenser.domain.mds;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class MdsRawStorageByDc {
    private final long id;
    private final List<DcStorage> storage;

    @JsonCreator
    public MdsRawStorageByDc(@JsonProperty("id") final long id,
                             @JsonProperty("storage") final List<DcStorage> storage) {
        this.id = id;
        this.storage = storage;
    }

    public long getId() {
        return id;
    }

    public List<DcStorage> getStorage() {
        return storage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MdsRawStorageByDc that = (MdsRawStorageByDc) o;
        return id == that.id && Objects.equals(storage, that.storage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, storage);
    }

    @Override
    public String toString() {
        return "MdsRawStorageByDc{" +
                "id=" + id +
                ", storage=" + storage +
                '}';
    }

    public static class DcStorage {
        private final String location;
        private final long amount;

        public DcStorage(@JsonProperty("location") final String location,
                         @JsonProperty("amount") final long amount) {
            this.location = location;
            this.amount = amount;
        }

        public String getLocation() {
            return location;
        }

        public long getAmount() {
            return amount;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            DcStorage dcStorage = (DcStorage) o;
            return amount == dcStorage.amount && Objects.equals(location, dcStorage.location);
        }

        @Override
        public int hashCode() {
            return Objects.hash(location, amount);
        }

        @Override
        public String toString() {
            return "DcStorage{" +
                    "location='" + location + '\'' +
                    ", amount=" + amount +
                    '}';
        }
    }
}
