package ru.yandex.qe.dispenser.domain.mds;

import com.fasterxml.jackson.annotation.JsonValue;

public enum StorageType {
    S3("s3-api"),
    MDS("mds"),
    AVATARS("avatars");

    private final String value;

    StorageType(final String value) {
        this.value = value;
    }

    @JsonValue
    public String getKey() {
        return value;
    }

    public static StorageType fromKey(final String key) {
        for (final StorageType value : values()) {
            if (value.getKey().equals(key)) {
                return value;
            }
        }
        return null;
    }
}
