package ru.yandex.qe.dispenser.domain.notifications;

import java.util.Objects;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.domain.Project;
import ru.yandex.qe.dispenser.domain.QuotaSpec;

// TODO Can use Quota instead of project, spec and overquotingTs
public class NotificationEntry {
    @NotNull
    private final Project project;
    @NotNull
    private final QuotaSpec spec;
    @NotNull
    private final Integer quotaLimit;
    @Nullable
    private final Long overquotingTs;

    public NotificationEntry(@NotNull final Project project, @NotNull final QuotaSpec spec, @NotNull final Integer quotaLimit, @Nullable final Long overquotingTs) {
        this.project = project;
        this.spec = spec;
        this.quotaLimit = quotaLimit;
        this.overquotingTs = overquotingTs;
    }

    @NotNull
    public Project getProject() {
        return project;
    }

    @NotNull
    public QuotaSpec getSpec() {
        return spec;
    }

    @NotNull
    public Integer getQuotaLimit() {
        return quotaLimit;
    }

    public boolean isOverquoting() {
        return quotaLimit == 100;
    }

    @Nullable
    public Long getOverquotingTs() {
        return overquotingTs;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final NotificationEntry that = (NotificationEntry) o;
        return Objects.equals(project, that.project) &&
                Objects.equals(spec, that.spec) &&
                Objects.equals(quotaLimit, that.quotaLimit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(project, spec, quotaLimit);
    }

    @Override
    public String toString() {
        return "NotificationPair{" +
                "project.key=" + project.getPublicKey() +
                ", spec.key=" + spec.getKey().getPublicKey() +
                ", quota_limit=" + quotaLimit +
                '}';
    }
}
