package ru.yandex.qe.dispenser.domain.property;

import java.util.Optional;

import javax.inject.Inject;

import org.springframework.stereotype.Component;

import ru.yandex.qe.dispenser.domain.dao.property.PropertyDao;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;

@Component
public class PropertyManager {

    private final PropertyDao propertyDao;

    @Inject
    public PropertyManager(final PropertyDao propertyDao) {
        this.propertyDao = propertyDao;
    }

    public Property setProperty(final String entityKey, final String propertyKey, final Property.Value<?> value) {
        final Optional<Property> property = Hierarchy.get().getPropertyReader().read(entityKey, propertyKey);

        return property.map(prop -> {
            if (value.get().getClass().equals(prop.getValue().get().getClass())) {
                final Property modifiedProperty = new Property(prop.getId(), prop.getEntityKey(), prop.getPropertyKey(), value);
                propertyDao.update(modifiedProperty);
                return modifiedProperty;
            }
            propertyDao.delete(prop);
            return null;
        }).orElseGet(() -> {
            return propertyDao.create(new Property(-1L, entityKey, propertyKey, value));
        });
    }

    public boolean deleteProperty(final String entityKey, final String propertyKey) {
        final Optional<Property> property = Hierarchy.get().getPropertyReader().read(entityKey, propertyKey);

        return property.map(propertyDao::delete)
                .orElse(false);
    }
}
