package ru.yandex.qe.dispenser.domain.request;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InMemoryRequestManager implements RequestManager {
    @NotNull
    private final Map<String, String> reqIds = new ConcurrentHashMap<>();

    private final ReentrantLock[] locks = new ReentrantLock[100];

    {
        for (int i = 0; i < locks.length; i++) {
            locks[i] = new ReentrantLock();
        }
    }


    @Override
    public boolean createRequest(@NotNull final String reqId, @NotNull final String data) {
        reqIds.put(reqId, data);
        final ReentrantLock lock = locks[Math.abs(reqId.hashCode()) % locks.length];
        //for test :(
        if (lock.isLocked()) {
            lock.unlock();
        }
        return true;
    }

    @Override
    public Optional<String> lockOrResult(final @NotNull String reqId) {
        locks[Math.abs(reqId.hashCode()) % locks.length].lock();
        if (reqIds.containsKey(reqId)) {
            locks[Math.abs(reqId.hashCode()) % locks.length].unlock();
            return Optional.of(reqIds.get(reqId));
        }
        return Optional.empty();
    }

    @Override
    public AutoCloseable localLock(@Nullable final String reqId, final long timeoutNanos) throws ConcurrentOperationException {
        return new AutoCloseable() {
            @Override
            public void close() throws Exception {

            }
        };
    }

    @Override
    public boolean removeOld() {
        return false;
    }

    @Override
    public boolean clear() {
        reqIds.clear();
        return true;
    }
}
