package ru.yandex.qe.dispenser.domain.request;

import java.util.Optional;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public interface RequestManager {
    @Transactional(propagation = Propagation.MANDATORY)
    boolean createRequest(@NotNull String reqId, @NotNull String data);

    @Transactional(propagation = Propagation.MANDATORY)
    Optional<String> lockOrResult(@NotNull final String reqId) throws ConcurrentOperationException;

    AutoCloseable localLock(@Nullable final String reqId, final long timeoutNanos) throws ConcurrentOperationException;

    boolean removeOld();

    boolean clear();
}
