package ru.yandex.qe.dispenser.domain.resources_model;

import java.util.Objects;
import java.util.Set;

import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.Segment;

public final class DeliverableResource {

    private final Resource resource;
    private final Set<Segment> segments;

    public DeliverableResource(Resource resource, Set<Segment> segments) {
        this.resource = resource;
        this.segments = segments;
    }

    public Resource getResource() {
        return resource;
    }

    public Set<Segment> getSegments() {
        return segments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliverableResource that = (DeliverableResource) o;
        return Objects.equals(resource, that.resource) &&
                Objects.equals(segments, that.segments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resource, segments);
    }

    @Override
    public String toString() {
        return "DeliverableResource{" +
                "resource=" + resource +
                ", segments=" + segments +
                '}';
    }

}
