package ru.yandex.qe.dispenser.domain.resources_model;

import java.time.Instant;
import java.util.Objects;
import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown = true)
public final class DeliveryResult {

    private final UUID folderId;
    private final long bigOrderId;
    private final UUID resourceId;
    private final UUID folderOperationId;
    private final Instant timestamp;
    private final UUID accountId;
    private final UUID accountOperationId;

    @JsonCreator
    public DeliveryResult(@JsonProperty("folderId") UUID folderId,
                          @JsonProperty("bigOrderId") long bigOrderId,
                          @JsonProperty("resourceId") UUID resourceId,
                          @JsonProperty("folderOperationId") UUID folderOperationId,
                          @JsonProperty("timestamp") Instant timestamp,
                          @JsonProperty("accountId") UUID accountId,
                          @JsonProperty("accountOperationId") UUID accountOperationId) {
        this.folderId = folderId;
        this.bigOrderId = bigOrderId;
        this.resourceId = resourceId;
        this.folderOperationId = folderOperationId;
        this.timestamp = timestamp;
        this.accountId = accountId;
        this.accountOperationId = accountOperationId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UUID getFolderId() {
        return folderId;
    }

    public long getBigOrderId() {
        return bigOrderId;
    }

    public UUID getResourceId() {
        return resourceId;
    }

    public UUID getFolderOperationId() {
        return folderOperationId;
    }

    public Instant getTimestamp() {
        return timestamp;
    }

    @Nullable
    public UUID getAccountId() {
        return accountId;
    }

    @Nullable
    public UUID getAccountOperationId() {
        return accountOperationId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryResult that = (DeliveryResult) o;
        return bigOrderId == that.bigOrderId && Objects.equals(folderId, that.folderId) && Objects.equals(resourceId,
                that.resourceId) && Objects.equals(folderOperationId, that.folderOperationId)
                && Objects.equals(timestamp, that.timestamp) && Objects.equals(accountId, that.accountId)
                && Objects.equals(accountOperationId, that.accountOperationId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(folderId, bigOrderId, resourceId, folderOperationId, timestamp, accountId, accountOperationId);
    }

    @Override
    public String toString() {
        return "DeliveryResult{" +
                "folderId=" + folderId +
                ", bigOrderId=" + bigOrderId +
                ", resourceId=" + resourceId +
                ", folderOperationId=" + folderOperationId +
                ", timestamp=" + timestamp +
                ", accountId=" + accountId +
                ", accountOperationId=" + accountOperationId +
                '}';
    }

    public static final class Builder {

        private UUID folderId;
        private Long bigOrderId;
        private UUID resourceId;
        private UUID folderOperationId;
        private Instant timestamp;
        private UUID accountId;
        private UUID accountOperationId;

        private Builder() {
        }

        public Builder folderId(UUID folderId) {
            this.folderId = folderId;
            return this;
        }

        public Builder bigOrderId(long bigOrderId) {
            this.bigOrderId = bigOrderId;
            return this;
        }

        public Builder resourceId(UUID resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder folderOperationId(UUID folderOperationId) {
            this.folderOperationId = folderOperationId;
            return this;
        }

        public Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder accountId(UUID accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder accountOperationId(UUID accountOperationId) {
            this.accountOperationId = accountOperationId;
            return this;
        }

        public DeliveryResult build() {
            return new DeliveryResult(folderId, bigOrderId, resourceId, folderOperationId, timestamp, accountId,
                    accountOperationId);
        }

    }

}
