package ru.yandex.qe.dispenser.domain.resources_model;

import java.util.Objects;
import java.util.UUID;

public final class ExternalDeliverableResource {

    private final UUID resourceId;

    public ExternalDeliverableResource(UUID resourceId) {
        this.resourceId = resourceId;
    }

    public UUID getResourceId() {
        return resourceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExternalDeliverableResource that = (ExternalDeliverableResource) o;
        return Objects.equals(resourceId, that.resourceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId);
    }

    @Override
    public String toString() {
        return "QuotaRequestDeliveryDestination{" +
                "resourceId=" + resourceId +
                '}';
    }

}
