package ru.yandex.qe.dispenser.domain.resources_model;

import java.util.Objects;
import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown = true)
public final class ExternalResource {

    private final UUID resourceId;
    private final long bigOrderId;
    private final long amount;
    private final String unitKey;
    private final UUID folderId;
    private final UUID accountId;
    private final UUID providerId;

    @JsonCreator
    public ExternalResource(@JsonProperty("resourceId") UUID resourceId,
                            @JsonProperty("bigOrderId") long bigOrderId,
                            @JsonProperty("amount") long amount,
                            @JsonProperty("unitKey") String unitKey,
                            @JsonProperty("folderId") UUID folderId,
                            @JsonProperty("accountId") UUID accountId,
                            @JsonProperty("providerId") UUID providerId) {
        this.resourceId = resourceId;
        this.bigOrderId = bigOrderId;
        this.amount = amount;
        this.unitKey = unitKey;
        this.folderId = folderId;
        this.accountId = accountId;
        this.providerId = providerId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UUID getResourceId() {
        return resourceId;
    }

    public long getBigOrderId() {
        return bigOrderId;
    }

    public long getAmount() {
        return amount;
    }

    public String getUnitKey() {
        return unitKey;
    }

    @Nullable
    public UUID getFolderId() {
        return folderId;
    }

    @Nullable
    public UUID getAccountId() {
        return accountId;
    }

    @Nullable
    public UUID getProviderId() {
        return providerId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExternalResource that = (ExternalResource) o;
        return bigOrderId == that.bigOrderId && amount == that.amount && Objects.equals(resourceId, that.resourceId)
                && Objects.equals(unitKey, that.unitKey) && Objects.equals(folderId, that.folderId)
                && Objects.equals(accountId, that.accountId) && Objects.equals(providerId, that.providerId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, bigOrderId, amount, unitKey, folderId, accountId, providerId);
    }

    @Override
    public String toString() {
        return "ExternalResource{" +
                "resourceId=" + resourceId +
                ", bigOrderId=" + bigOrderId +
                ", amount=" + amount +
                ", unitKey='" + unitKey + '\'' +
                ", folderId=" + folderId +
                ", accountId=" + accountId +
                ", providerId=" + providerId +
                '}';
    }

    public static final class Builder {

        private UUID resourceId;
        private Long bigOrderId;
        private Long amount;
        private String unitKey;
        private UUID folderId;
        private UUID accountId;
        private UUID providerId;

        private Builder() {
        }

        public Builder resourceId(UUID resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder bigOrderId(long bigOrderId) {
            this.bigOrderId = bigOrderId;
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder unitKey(String unitKey) {
            this.unitKey = unitKey;
            return this;
        }

        public Builder folderId(UUID folderId) {
            this.folderId = folderId;
            return this;
        }

        public Builder accountId(UUID accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder providerId(UUID providerId) {
            this.providerId = providerId;
            return this;
        }

        public ExternalResource build() {
            Objects.requireNonNull(resourceId, "ResourceId is required");
            Objects.requireNonNull(bigOrderId, "BigOrderId is required");
            Objects.requireNonNull(amount, "Amount is required");
            Objects.requireNonNull(unitKey, "UnitKey is required");
            return new ExternalResource(resourceId, bigOrderId, amount, unitKey, folderId, accountId, providerId);
        }

    }

}
