package ru.yandex.qe.dispenser.domain.resources_model;

import java.util.Objects;

public final class MappedResources {

    private final QuotaRequestDelivery delivery;

    public MappedResources(QuotaRequestDelivery delivery) {
        this.delivery = delivery;
    }

    public QuotaRequestDelivery getDelivery() {
        return delivery;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MappedResources that = (MappedResources) o;
        return Objects.equals(delivery, that.delivery);
    }

    @Override
    public int hashCode() {
        return Objects.hash(delivery);
    }

    @Override
    public String toString() {
        return "MappedResources{" +
                "delivery=" + delivery +
                '}';
    }

}
