package ru.yandex.qe.dispenser.domain.resources_model;

import java.util.Map;
import java.util.Objects;
import java.util.Set;

import ru.yandex.qe.dispenser.domain.QuotaChangeRequest;

public final class QuotaChangeRequestDeliveryMapping {

    private final Map<DeliverableResource, Set<ExternalDeliverableResource>> deliveryMapping;
    private final QuotaChangeRequest quotaChangeRequest;

    public QuotaChangeRequestDeliveryMapping(
            Map<DeliverableResource, Set<ExternalDeliverableResource>> deliveryMapping,
            QuotaChangeRequest quotaChangeRequest) {
        this.deliveryMapping = deliveryMapping;
        this.quotaChangeRequest = quotaChangeRequest;
    }

    public Map<DeliverableResource, Set<ExternalDeliverableResource>> getDeliveryMapping() {
        return deliveryMapping;
    }

    public QuotaChangeRequest getQuotaChangeRequest() {
        return quotaChangeRequest;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotaChangeRequestDeliveryMapping that = (QuotaChangeRequestDeliveryMapping) o;
        return Objects.equals(deliveryMapping, that.deliveryMapping) &&
                Objects.equals(quotaChangeRequest, that.quotaChangeRequest);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deliveryMapping, quotaChangeRequest);
    }

    @Override
    public String toString() {
        return "QuotaChangeRequestDeliveryMapping{" +
                "deliveryMapping=" + deliveryMapping +
                ", quotaChangeRequest=" + quotaChangeRequest +
                '}';
    }

}
