package ru.yandex.qe.dispenser.domain.resources_model;

import java.util.Map;
import java.util.Objects;

public final class QuotaChangeRequestsDeliveryMappings {

    private final Map<Long, QuotaChangeRequestDeliveryMapping> mappingsByRequestId;

    public QuotaChangeRequestsDeliveryMappings(
            Map<Long, QuotaChangeRequestDeliveryMapping> mappingsByRequestId) {
        this.mappingsByRequestId = mappingsByRequestId;
    }

    public Map<Long, QuotaChangeRequestDeliveryMapping> getMappingsByRequestId() {
        return mappingsByRequestId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotaChangeRequestsDeliveryMappings that = (QuotaChangeRequestsDeliveryMappings) o;
        return Objects.equals(mappingsByRequestId, that.mappingsByRequestId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(mappingsByRequestId);
    }

    @Override
    public String toString() {
        return "QuotaChangeRequestsDeliveryMappings{" +
                "mappingsByRequestId=" + mappingsByRequestId +
                '}';
    }

}
