package ru.yandex.qe.dispenser.domain.resources_model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeRequest;
import ru.yandex.qe.dispenser.domain.QuotaChangeRequest;

public class QuotaRequestDeliveryContext {
    private final QuotaRequestDelivery quotaRequestDelivery;
    private final List<QuotaChangeRequest.Change> affectedChanges;

    public QuotaRequestDeliveryContext(QuotaRequestDelivery quotaRequestDelivery,
                                       List<QuotaChangeRequest.Change> affectedChanges) {
        this.quotaRequestDelivery = quotaRequestDelivery;
        this.affectedChanges = affectedChanges;
    }

    public QuotaRequestDelivery getQuotaRequestDelivery() {
        return quotaRequestDelivery;
    }

    public List<QuotaChangeRequest.Change> getAffectedChanges() {
        return affectedChanges;
    }

    public View toView() {
        final List<DiQuotaChangeRequest.Change> changeViews = affectedChanges.stream()
                .map(QuotaChangeRequest.Change::toView)
                .collect(Collectors.toList());
        return new View(quotaRequestDelivery.toView(), changeViews);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private QuotaRequestDelivery quotaRequestDelivery;
        private List<QuotaChangeRequest.Change> affectedChanges = new ArrayList<>();

        public Builder setQuotaRequestDelivery(QuotaRequestDelivery quotaRequestDelivery) {
            this.quotaRequestDelivery = quotaRequestDelivery;
            return this;
        }

        public Builder setAffectedChanges(List<QuotaChangeRequest.Change> affectedChanges) {
            if (affectedChanges != null) {
                this.affectedChanges = affectedChanges;
            }
            return this;
        }

        public Builder addAffectedChange(QuotaChangeRequest.Change change) {
            affectedChanges.add(change);
            return this;
        }

        public QuotaRequestDeliveryContext build() {
            return new QuotaRequestDeliveryContext(quotaRequestDelivery, affectedChanges);
        }
    }

    public static class View {
        private final QuotaRequestDelivery.View quotaRequestDelivery;
        private final List<DiQuotaChangeRequest.Change> affectedChanges;

        @JsonCreator
        public View(@JsonProperty("quotaRequestDelivery") QuotaRequestDelivery.View quotaRequestDelivery,
                    @JsonProperty("affectedChanges")List<DiQuotaChangeRequest.Change> affectedChanges) {
            this.quotaRequestDelivery = quotaRequestDelivery;
            this.affectedChanges = affectedChanges;
        }

        public QuotaRequestDelivery.View getQuotaRequestDelivery() {
            return quotaRequestDelivery;
        }

        public List<DiQuotaChangeRequest.Change> getAffectedChanges() {
            return affectedChanges;
        }
    }
}
