package ru.yandex.qe.dispenser.domain.resources_model;

import java.util.Objects;
import java.util.UUID;

public final class ResourceModelMappingTarget {

    private final long numerator;
    private final long denominator;
    private final UUID externalResourceId;
    private final String externalResourceBaseUnitKey;
    private final String key;

    public ResourceModelMappingTarget(long numerator, long denominator, UUID externalResourceId,
                                      String externalResourceBaseUnitKey, String key) {
        this.numerator = numerator;
        this.denominator = denominator;
        this.externalResourceId = externalResourceId;
        this.externalResourceBaseUnitKey = externalResourceBaseUnitKey;
        this.key = key;
    }


    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ResourceModelMappingTarget value) {
        return new Builder(value);
    }

    public long getNumerator() {
        return numerator;
    }

    public long getDenominator() {
        return denominator;
    }

    public UUID getExternalResourceId() {
        return externalResourceId;
    }

    public String getExternalResourceBaseUnitKey() {
        return externalResourceBaseUnitKey;
    }

    public String getKey() {
        return key;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceModelMappingTarget that = (ResourceModelMappingTarget) o;
        return numerator == that.numerator &&
                denominator == that.denominator &&
                Objects.equals(externalResourceId, that.externalResourceId) &&
                Objects.equals(key, that.key) &&
                Objects.equals(externalResourceBaseUnitKey, that.externalResourceBaseUnitKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(numerator, denominator, externalResourceId, externalResourceBaseUnitKey, key);
    }

    @Override
    public String toString() {
        return "ResourceModelMappingTarget{" +
                "numerator=" + numerator +
                ", denominator=" + denominator +
                ", externalResourceId=" + externalResourceId +
                ", externalResourceBaseUnitKey='" + externalResourceBaseUnitKey + '\'' +
                ", key='" + key + '\'' +
                '}';
    }

    public static final class Builder {

        private Long numerator;
        private Long denominator;
        private UUID externalResourceId;
        private String externalResourceBaseUnitKey;
        private String key;

        private Builder() {
        }

        private Builder(ResourceModelMappingTarget value) {
            this.numerator = value.numerator;
            this.denominator = value.denominator;
            this.externalResourceId = value.externalResourceId;
            this.externalResourceBaseUnitKey = value.externalResourceBaseUnitKey;
        }

        public Builder numerator(long numerator) {
            this.numerator = numerator;
            return this;
        }

        public Builder denominator(long denominator) {
            this.denominator = denominator;
            return this;
        }

        public Builder externalResourceId(UUID externalResourceId) {
            this.externalResourceId = externalResourceId;
            return this;
        }

        public Builder externalResourceBaseUnitKey(String externalResourceBaseUnitKey) {
            this.externalResourceBaseUnitKey = externalResourceBaseUnitKey;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public ResourceModelMappingTarget build() {
            Objects.requireNonNull(numerator, "Numerator is required");
            Objects.requireNonNull(denominator, "Denominator is required");
            Objects.requireNonNull(externalResourceId, "ExternalResourceId is required");
            Objects.requireNonNull(externalResourceBaseUnitKey, "ExternalResourceBaseUnitKey is required");
            return new ResourceModelMappingTarget(numerator, denominator, externalResourceId,
                    externalResourceBaseUnitKey, key);
        }

    }

}
