package ru.yandex.qe.dispenser.domain.staff;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public final class StaffDepartmentGroup extends StaffGroup {

    private final List<StaffGroup> ancestors;

    @JsonCreator
    public StaffDepartmentGroup(@JsonProperty("id") final long id, @JsonProperty("url") final String url,
                                @JsonProperty("type") final StaffGroupType type, @JsonProperty("is_deleted") final boolean deleted,
                                @JsonProperty("ancestors") final List<StaffGroup> ancestors) {
        super(id, url, type, deleted);
        this.ancestors = ancestors;
    }

    public List<StaffGroup> getAncestors() {
        return ancestors;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        final StaffDepartmentGroup that = (StaffDepartmentGroup) o;
        return Objects.equals(ancestors, that.ancestors);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), ancestors);
    }

    @Override
    public String toString() {
        return "StaffDepartmentGroup{" +
                "ancestors=" + ancestors +
                "} " + super.toString();
    }

}
