package ru.yandex.qe.dispenser.domain.staff;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class StaffGroup {

    private final long id;
    private final String url;
    private final StaffGroupType type;
    private final boolean deleted;

    @JsonCreator
    public StaffGroup(@JsonProperty("id") final long id, @JsonProperty("url") final String url, @JsonProperty("type") final StaffGroupType type,
                      @JsonProperty("is_deleted") final boolean deleted) {
        this.id = id;
        this.url = url;
        this.type = type;
        this.deleted = deleted;
    }

    public long getId() {
        return id;
    }

    public String getUrl() {
        return url;
    }

    public StaffGroupType getType() {
        return type;
    }

    @JsonProperty("is_deleted")
    public boolean isDeleted() {
        return deleted;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final StaffGroup that = (StaffGroup) o;
        return id == that.id &&
                deleted == that.deleted &&
                Objects.equals(url, that.url) &&
                type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, url, type, deleted);
    }

    @Override
    public String toString() {
        return "StaffGroup{" +
                "id=" + id +
                ", url='" + url + '\'' +
                ", type=" + type +
                ", deleted=" + deleted +
                '}';
    }

}
