package ru.yandex.qe.dispenser.domain.staff;

import java.util.EnumSet;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum StaffGroupType {

    UNKNOWN(""),
    DEPARTMENT("department"),
    SERVICE("service"),
    SERVICE_ROLE("servicerole"),
    WIKI("wiki"),
    ;

    private final String value;

    private static final EnumSet<StaffGroupType> KNOWN_TYPES = EnumSet.complementOf(EnumSet.of(UNKNOWN));

    StaffGroupType(final String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @JsonCreator
    public static StaffGroupType cons(final String value) {
        return KNOWN_TYPES.stream().filter(t -> t.value.equals(value)).findFirst().orElse(UNKNOWN);
    }

}
