package ru.yandex.qe.dispenser.domain.staff;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public final class StaffPage<T> {

    private final List<T> result;
    private final long total;
    private final long pages;

    @JsonCreator
    public StaffPage(@JsonProperty("result") final List<T> result, @JsonProperty("total") final long total, @JsonProperty("pages") final long pages) {
        this.result = result;
        this.total = total;
        this.pages = pages;
    }

    public List<T> getResult() {
        return result;
    }

    public long getTotal() {
        return total;
    }

    public long getPages() {
        return pages;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final StaffPage<?> staffPage = (StaffPage<?>) o;
        return total == staffPage.total &&
                pages == staffPage.pages &&
                Objects.equals(result, staffPage.result);
    }

    @Override
    public int hashCode() {
        return Objects.hash(result, total, pages);
    }

    @Override
    public String toString() {
        return "StaffPage{" +
                "result=" + result +
                ", total=" + total +
                ", pages=" + pages +
                '}';
    }

}
