package ru.yandex.qe.dispenser.domain.staff;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public final class StaffPerson {

    private final long id;
    private final String uid;
    private final String login;
    private final boolean deleted;
    private final Official official;
    private final List<PersonGroup> groups;
    private final StaffDepartmentGroup departmentGroup;

    @JsonCreator
    public StaffPerson(@JsonProperty("id") final long id, @JsonProperty("uid") final String uid, @JsonProperty("login") final String login,
                       @JsonProperty("is_deleted") final boolean deleted, @JsonProperty("official") final Official official,
                       @JsonProperty("groups") final List<PersonGroup> groups, @JsonProperty("department_group") final StaffDepartmentGroup departmentGroup) {
        this.id = id;
        this.uid = uid;
        this.login = login;
        this.deleted = deleted;
        this.official = official;
        this.groups = groups;
        this.departmentGroup = departmentGroup;
    }

    public long getId() {
        return id;
    }

    public String getUid() {
        return uid;
    }

    public String getLogin() {
        return login;
    }

    @JsonProperty("is_deleted")
    public boolean isDeleted() {
        return deleted;
    }

    public Official getOfficial() {
        return official;
    }

    public List<PersonGroup> getGroups() {
        return groups;
    }

    @JsonProperty("department_group")
    public StaffDepartmentGroup getDepartmentGroup() {
        return departmentGroup;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final StaffPerson that = (StaffPerson) o;
        return id == that.id &&
                deleted == that.deleted &&
                Objects.equals(uid, that.uid) &&
                Objects.equals(login, that.login) &&
                Objects.equals(official, that.official) &&
                Objects.equals(groups, that.groups) &&
                Objects.equals(departmentGroup, that.departmentGroup);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, uid, login, deleted, official, groups, departmentGroup);
    }

    @Override
    public String toString() {
        return "StaffPerson{" +
                "id=" + id +
                ", uid='" + uid + '\'' +
                ", login='" + login + '\'' +
                ", deleted=" + deleted +
                ", official=" + official +
                ", groups=" + groups +
                ", departmentGroup=" + departmentGroup +
                '}';
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Official {

        private final StaffPersonAffiliation affiliation;
        private final boolean dismissed;
        private final boolean robot;

        @JsonCreator
        public Official(@JsonProperty("affiliation") final StaffPersonAffiliation affiliation,
                        @JsonProperty("is_dismissed") final boolean dismissed, @JsonProperty("is_robot") final boolean robot) {
            this.affiliation = affiliation;
            this.dismissed = dismissed;
            this.robot = robot;
        }

        public StaffPersonAffiliation getAffiliation() {
            return affiliation;
        }

        @JsonProperty("is_dismissed")
        public boolean isDismissed() {
            return dismissed;
        }

        @JsonProperty("is_robot")
        public boolean isRobot() {
            return robot;
        }

        @Override
        public boolean equals(final Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            final Official official = (Official) o;
            return dismissed == official.dismissed &&
                    robot == official.robot &&
                    affiliation == official.affiliation;
        }

        @Override
        public int hashCode() {
            return Objects.hash(affiliation, dismissed, robot);
        }

        @Override
        public String toString() {
            return "Official{" +
                    "affiliation=" + affiliation +
                    ", dismissed=" + dismissed +
                    ", robot=" + robot +
                    '}';
        }

    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class PersonGroup {

        private final StaffGroup group;

        @JsonCreator
        public PersonGroup(@JsonProperty("group") final StaffGroup group) {
            this.group = group;
        }

        public StaffGroup getGroup() {
            return group;
        }

        @Override
        public boolean equals(final Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            final PersonGroup that = (PersonGroup) o;
            return Objects.equals(group, that.group);
        }

        @Override
        public int hashCode() {
            return Objects.hash(group);
        }

        @Override
        public String toString() {
            return "PersonGroup{" +
                    "group=" + group +
                    '}';
        }

    }

}
