package ru.yandex.qe.dispenser.domain.staff;

import java.util.EnumSet;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum StaffPersonAffiliation {

    UNKNOWN(""),
    YANDEX("yandex"),
    YA_MONEY("yamoney"),
    EXTERNAL("external"),
    ;

    private final String value;

    private static final EnumSet<StaffPersonAffiliation> KNOWN_TYPES = EnumSet.complementOf(EnumSet.of(UNKNOWN));

    StaffPersonAffiliation(final String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @JsonCreator
    public static StaffPersonAffiliation cons(final String value) {
        return KNOWN_TYPES.stream().filter(t -> t.value.equals(value)).findFirst().orElse(UNKNOWN);
    }

}
