package ru.yandex.qe.dispenser.domain.support;

import java.util.Map;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiMetaValueSet;
import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeCause;
import ru.yandex.qe.dispenser.api.v1.request.DiProcessingMode;
import ru.yandex.qe.dispenser.domain.Entity;
import ru.yandex.qe.dispenser.domain.Project;

public interface EntityOperation {
    @NotNull
    DiProcessingMode getMode();

    @NotNull
    Entity getEntity();

    @NotNull
    default DiMetaValueSet getMetaValues() {
        return DiMetaValueSet.EMPTY;
    }

    @Nullable
    DiQuotaChangeCause getCause();

    void processOverUsages(@NotNull Map<Project, Integer> usages);
}
