package ru.yandex.qe.dispenser.domain.support;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeCause;
import ru.yandex.qe.dispenser.api.v1.request.DiProcessingMode;
import ru.yandex.qe.dispenser.domain.Entity;

public abstract class EntityOperationBase implements EntityOperation {
    @NotNull
    private final DiProcessingMode mode;
    @NotNull
    private final Entity entity;
    @Nullable
    private final DiQuotaChangeCause cause;

    protected EntityOperationBase(@NotNull final DiProcessingMode mode,
                                  @NotNull final Entity entity,
                                  @Nullable final DiQuotaChangeCause cause) {
        this.mode = mode;
        this.entity = entity;
        this.cause = cause;
    }

    @NotNull
    @Override
    public DiProcessingMode getMode() {
        return mode;
    }

    @NotNull
    @Override
    public final Entity getEntity() {
        return entity;
    }

    @Nullable
    @Override
    public final DiQuotaChangeCause getCause() {
        return cause;
    }
}
