package ru.yandex.qe.dispenser.domain.support;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.request.DiEntityOwnership;
import ru.yandex.qe.dispenser.domain.Entity;
import ru.yandex.qe.dispenser.domain.Project;

public final class EntityOwnership {
    @NotNull
    private final Entity entity;
    @NotNull
    private final Project project;
    private final int usages;

    public EntityOwnership(@NotNull final Entity entity, @NotNull final Project project, final int usages) {
        this.entity = entity;
        this.project = project;
        this.usages = usages;
    }

    @NotNull
    public Entity getEntity() {
        return entity;
    }

    @NotNull
    public Project getProject() {
        return project;
    }

    public int getUsages() {
        return usages;
    }

    @NotNull
    public EntityOwnership increment(final int diff) {
        return new EntityOwnership(entity, project, usages + diff);
    }

    @NotNull
    public DiEntityOwnership toPersonalView() {
        return DiEntityOwnership.builder().entity(entity.toView(true)).project(project.toPersonalView()).usages(usages).build();
    }

    public DiEntityOwnership toView() {
        return DiEntityOwnership.builder().entity(entity.toView()).project(project.toView()).usages(usages).build();
    }
}
