package ru.yandex.qe.dispenser.domain.support;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiMetaValueSet;
import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeCause;
import ru.yandex.qe.dispenser.api.v1.request.DiProcessingMode;
import ru.yandex.qe.dispenser.domain.Entity;
import ru.yandex.qe.dispenser.domain.Project;
import ru.yandex.qe.dispenser.domain.dao.project.ProjectUtils;
import ru.yandex.qe.dispenser.domain.util.MathUtils;

public final class EntityUsageDiff extends EntityOperationBase implements EntityOperation {
    @NotNull
    private final Project project;
    @NotNull
    private final DiMetaValueSet metaValues;

    private final int usages;

    // TODO: builder
    public EntityUsageDiff(@NotNull final DiProcessingMode mode,
                           @NotNull final Entity entity,
                           @NotNull final Project project,
                           @NotNull final DiMetaValueSet metaValues,
                           final int usageDiff,
                           @Nullable final DiQuotaChangeCause cause) {
        super(mode, entity, cause);
        this.project = project;
        this.metaValues = metaValues;
        this.usages = usageDiff;
    }

    @NotNull
    public Project getProject() {
        return project;
    }

    @NotNull
    @Override
    public DiMetaValueSet getMetaValues() {
        return metaValues;
    }

    public int getUsages() {
        return usages;
    }

    @Override
    public void processOverUsages(@NotNull final Map<Project, Integer> usages) {
        if (MathUtils.increment(usages, project, getUsages()) >= 0) {
            return;
        }
        final List<Project> brothers = new ArrayList<>(ProjectUtils.brothers(project));
        brothers.sort(Comparator.comparing(p -> usages.getOrDefault(p, 0)).reversed());
        for (final Project brother : brothers) {
            final int brotherUsages = usages.getOrDefault(brother, 0);
            final int projectUsages = usages.getOrDefault(project, 0);
            if (projectUsages >= 0) {
                return;
            }

            final int transferUsages = Math.min(brotherUsages, -projectUsages);

            MathUtils.increment(usages, brother, -transferUsages);
            MathUtils.increment(usages, project, transferUsages);
        }
        if (usages.getOrDefault(project, 0) < 0) {
            switch (getMode()) {
                case IGNORE_UNKNOWN_ENTITIES_AND_USAGES:
                    usages.remove(project);
                    break;
                case ROLLBACK_ON_ERROR:
                default:
                    throw new IllegalArgumentException("Not enough usages for release!");
            }
        }
    }
}
