package ru.yandex.qe.dispenser.domain.support;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.request.DiActionType;

public final class Operation<T> {
    private final int id;
    @NotNull
    private final DiActionType type;
    @NotNull
    private final T action;

    public Operation(final int id, @NotNull final DiActionType type, @NotNull final T action) {
        this.id = id;
        this.type = type;
        this.action = action;
    }

    public int getId() {
        return id;
    }

    @NotNull
    public DiActionType getType() {
        return type;
    }

    @NotNull
    public T getAction() {
        return action;
    }
}
