package ru.yandex.qe.dispenser.domain.support;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OperationResult {
    private final int operationId;
    private final boolean isSuccess;
    @Nullable
    private final String errorReason;

    @NotNull
    public static OperationResult success(final int operationId) {
        return new OperationResult(operationId, true, null);
    }

    @NotNull
    public static OperationResult fail(final int operationId, @NotNull final String errorReason) {
        return new OperationResult(operationId, false, errorReason);
    }

    private OperationResult(@JsonProperty("operationId") final int operationId,
                            @JsonProperty("isSuccess") final boolean isSuccess,
                            @JsonProperty("errorReason") @Nullable final String errorReason) {
        this.operationId = operationId;
        this.isSuccess = isSuccess;
        this.errorReason = errorReason;
    }

    public int getOperationId() {
        return operationId;
    }

    @JsonProperty("isSuccess")
    public boolean isSuccess() {
        return isSuccess;
    }

    @Nullable
    public String getErrorReason() {
        return errorReason;
    }
}
