package ru.yandex.qe.dispenser.domain.support;

import java.util.Set;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeCause;
import ru.yandex.qe.dispenser.domain.Project;
import ru.yandex.qe.dispenser.domain.Quota;
import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.Segment;

public class QuotaDiff {
    @NotNull
    private final Resource resource;
    @NotNull
    private final Project project;
    private final long diff;
    @Nullable
    private final DiQuotaChangeCause cause;
    private final @NotNull Set<Segment> segments;

    public QuotaDiff(@NotNull final Resource resource,
                     @NotNull final Project project,
                     final long diff,
                     @Nullable final DiQuotaChangeCause cause,
                     @NotNull final Set<Segment> segments) {
        this.resource = resource;
        this.project = project;
        this.diff = diff;
        this.cause = cause;
        this.segments = segments;
    }

    @NotNull
    public Resource getResource() {
        return resource;
    }

    @NotNull
    public Project getProject() {
        return project;
    }

    public long getDiff() {
        return diff;
    }

    @Nullable
    public DiQuotaChangeCause getCause() {
        return cause;
    }

    @NotNull
    public Set<Segment> getSegments() {
        return segments;
    }

    public boolean isFor(@NotNull final Quota quota) {
        return getResource().equals(quota.getResource()) && getProject().equals(quota.getProject()) && getSegments().equals(quota.getSegments());
    }
}
