package ru.yandex.qe.dispenser.domain.tracker;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.startrek.client.model.CommentCreate;
import ru.yandex.startrek.client.model.Issue;
import ru.yandex.startrek.client.model.IssueCreate;
import ru.yandex.startrek.client.model.IssueUpdate;

@Component
@ParametersAreNonnullByDefault
public interface TrackerManager {
    String createIssues(final IssueCreate issueCreate);

    void executeTransition(final String issueKey, final String targetStatusKey, final IssueUpdate issueUpdate) throws IllegalTransitionException;

    void updateIssue(final String issueKey, final IssueUpdate issueUpdate);

    Issue getIssue(final String issueKey);

    void createComment(final String issueKey, final CommentCreate comment);
}
