package ru.yandex.qe.dispenser.domain.util;

import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

import org.jetbrains.annotations.NotNull;

public final class DateTimeUtils {
    private static final ZoneId MSK_TIME_ZONE = ZoneId.of("Europe/Moscow");
    private static final DateTimeFormatter MSK_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm 'MSK'");

    private DateTimeUtils() {
    }

    public static LocalTime getCurrentMskTime() {
        return LocalTime.now(MSK_TIME_ZONE);
    }

    public static String formatToMskDateTime(final long timestamp) {
        return Instant.ofEpochMilli(timestamp).atZone(MSK_TIME_ZONE).format(MSK_DATE_TIME_FORMATTER);
    }

    public static Instant parse(@NotNull final String instant) {
        try {
            return Instant.parse(instant);
        } catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Incorrect time format for value '" + instant + "'. Expected format: yyyy-MM-dd'T'HH:mm:ss'Z'");
        }
    }
}
