package ru.yandex.qe.dispenser.domain.util;

import com.google.common.collect.ImmutableList;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Errors<T> {

    public static <T> Errors<T> of(final T errorMessage) {
        final Errors<T> errors = new Errors<>();
        errors.add(errorMessage);
        return errors;
    }

    public static <T> Errors<T> of() {
        return new Errors<>();
    }

    public final List<T> errors;

    public Errors(final List<T> errors) {
        this.errors = ImmutableList.copyOf(errors);
    }

    public List<T> getErrors() {
        return errors;
    }

    public boolean hasErrors() {
        return !errors.isEmpty();
    }

    public boolean isEmpty() {
        return errors.isEmpty();
    }

    public Errors() {
        this.errors = new ArrayList<>();
    }

    public void add(final T errorMessage) {
        errors.add(errorMessage);
    }

    public Errors<T> add(final Errors<T> other) {
        errors.addAll(other.getErrors());
        return this;
    }

    public <R> Errors<R> map(Function<T, R> mapper) {
        final List<R> mappedErrors = errors.stream()
                .map(mapper)
                .collect(Collectors.toList());
        return new Errors<>(mappedErrors);
    }
}
