package ru.yandex.qe.dispenser.domain.util;

import java.util.concurrent.Callable;

import org.jetbrains.annotations.NotNull;

public interface ExRunnable {
    void run() throws Exception;

    @NotNull
    default Runnable toRunnable() {
        return () -> {
            try {
                run();
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @NotNull
    default Callable<Void> toCallable() {
        return () -> {
            run();
            return null;
        };
    }

    @NotNull
    static Runnable runnable(@NotNull final ExRunnable r) {
        return r.toRunnable();
    }
}
