package ru.yandex.qe.dispenser.domain.util;

import java.io.File;
import java.io.FileNotFoundException;

import org.jetbrains.annotations.NotNull;

public enum FileUtils {
    ;

    @NotNull
    public static File find(@NotNull final String existingRelativePath) throws FileNotFoundException {
        for (File workDir = new File(System.getProperty("user.dir")); workDir != null; workDir = workDir.getParentFile()) {
            final File candidate = new File(workDir, existingRelativePath);
            if (candidate.exists()) {
                return candidate;
            }
        }
        throw new FileNotFoundException(existingRelativePath);
    }
}
