package ru.yandex.qe.dispenser.domain.util;

import java.util.function.Consumer;

import org.jetbrains.annotations.NotNull;

public final class FunctionalUtils {
    private FunctionalUtils() {
    }

    @NotNull
    public static <T> Consumer<T> withExceptionWrapping(@NotNull final ThrowingConsumer<T> consumer) {
        return consumer;
    }

    public static void throwIfUnrecoverable(Throwable e) throws Error {
        if (e instanceof OutOfMemoryError || e instanceof InternalError || e instanceof UnknownError) {
            throw (VirtualMachineError) e;
        }
    }

}
