package ru.yandex.qe.dispenser.domain.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

import org.jetbrains.annotations.NotNull;

public enum HttpTools {
    ;

    public static boolean pingHost(@NotNull final String host, final int port, final int timeout) {
        try (Socket socket = new Socket()) {
            socket.connect(new InetSocketAddress(host, port), timeout);
            return true;
        } catch (IOException ignored) {
            return false; // Either timeout or unreachable or failed DNS lookup.
        }
    }
}
