package ru.yandex.qe.dispenser.domain.util;

import java.util.Locale;
import java.util.Optional;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;

import ru.yandex.qe.dispenser.domain.i18n.LocalizableString;

public final class LocalizationUtils {

    private static final Logger LOG = LoggerFactory.getLogger(LocalizationUtils.class);

    private LocalizationUtils() {}

    public static Optional<String> resolve(final MessageSource source, final LocalizableString string, final Locale locale) {
        try {
            return Optional.of(source.getMessage(string.getKey(), string.getArgs(), locale));
        } catch (NoSuchMessageException e) {
            LOG.warn("Localization error", e);
            return Optional.empty();
        }
    }

    public static String resolveWithDefaultAsKey(final MessageSource source, final LocalizableString string, final Locale locale) {
        return resolve(source, string, locale).orElse(string.getKey());
    }

    public static String resolve(final MessageSource source, final LocalizableString string, final Locale locale, final String defaultMessage) {
        return resolve(source, string, locale).orElse(defaultMessage);
    }
}
