package ru.yandex.qe.dispenser.domain.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;

import org.jetbrains.annotations.NotNull;

public enum MoreFunctions {
    ;

    @NotNull
    public static <K, V, T extends Map<K, V>> BinaryOperator<T> combiner() {
        return (c1, c2) -> {
            c1.putAll(c2);
            return c1;
        };
    }

    @NotNull
    public static <T> BinaryOperator<T> leftProjection() {
        return (t1, t2) -> t1;
    }

    @NotNull
    public static <T> BinaryOperator<T> rightProjection() {
        return (t1, t2) -> t2;
    }

    @NotNull
    static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    @NotNull
    public static <T, R> Function<T, R> unchecked(@NotNull final IOFunction<T, R> f) {
        return t -> {
            try {
                return f.apply(t);
            } catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    @NotNull
    public static BinaryOperator<Integer> count() {
        return (a, b) -> a + b;
    }

    @NotNull
    public static BinaryOperator<Long> sum() {
        return (a, b) -> a + b;
    }
}
