package ru.yandex.qe.dispenser.domain.util;

import java.util.Optional;

import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;
import ru.yandex.qe.dispenser.domain.property.Property;

public final class PropertyUtils {
    private PropertyUtils() {
    }

    /**
     * @return Property value or defaultValue if property is absent.
     */
    public static boolean readBoolean(final String entityKey, final String propertyKey, final boolean defaultValue) {
        return read(entityKey, propertyKey, Property.Type.BOOLEAN).orElse(defaultValue);
    }

    public static String readString(final String entityKey, final String propertyKey) {
        return readString(entityKey, propertyKey, null);
    }

    public static String readString(final String entityKey, final String propertyKey, final String defaultValue) {
        return read(entityKey, propertyKey, Property.Type.STRING).orElse(defaultValue);
    }

    public static Optional<String> readStringOptional(final String entityKey, final String propertyKey) {
        return read(entityKey, propertyKey, Property.Type.STRING);
    }

    private static <T> Optional<T> read(final String entityKey, final String propertyKey, final Property.Type<T> propertyType) {
        return Hierarchy.get()
                .getPropertyReader()
                .read(entityKey, propertyKey)
                .map(property -> property.getValue().getAs(propertyType));
    }
}
