package ru.yandex.qe.dispenser.domain.util;

import java.util.Collections;
import java.util.List;

import ru.yandex.qe.dispenser.domain.index.LongIndexable;

public class RelativePage<T extends LongIndexable> {
    private final List<T> items;
    private final boolean last;

    public RelativePage(final List<T> items, final boolean last) {
        this.items = items;
        this.last = last;
    }

    public boolean isLast() {
        return last;
    }

    public List<T> getItems() {
        return items;
    }

    public static <T extends LongIndexable> RelativePage<T> middle(final List<T> items) {
        return new RelativePage<>(items, false);
    }

    public static <T extends LongIndexable> RelativePage<T> last(final List<T> items) {
        return new RelativePage<>(items, true);
    }

    public static <T extends LongIndexable> RelativePage<T> empty() {
        return new RelativePage<>(Collections.emptyList(),true);
    }
}
