package ru.yandex.qe.dispenser.domain.util;

import java.util.function.Consumer;

import com.google.common.base.Throwables;

/**
 * Established by terry
 * on 25.01.16.
 */
@FunctionalInterface
public interface ThrowingConsumer<T> extends Consumer<T> {

    @Override
    default void accept(final T arg) {
        try {
            acceptThrows(arg);
        } catch (final Throwable e) {
            throw Throwables.propagate(e);
        }
    }

    void acceptThrows(T arg) throws Exception;
}
