package ru.yandex.qe.dispenser.domain.util.clickhouse;

public final class ClickHouseDataType {

    private final String name;

    ClickHouseDataType(final String name) {
        this.name = name;
    }

    public String name() {
        return name;
    }

    @Override
    public String toString() {
        return name;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final ClickHouseDataType that = (ClickHouseDataType) o;

        return name.equals(that.name);

    }

    @Override
    public int hashCode() {
        return name.hashCode();
    }
}
